#include <bits/stdc++.h>
using namespace std;

const int N = 10000000;

bool isNotPrime[N + 5];
int numPrimes[N + 5];

void buildPrime(){
    for(int i = 2; i <= N; ++i){
        if(isNotPrime[i])
            continue;
        for(int j = 2; i * j <= N; ++j){
            isNotPrime[i * j] = true;
        }
    }

    numPrimes[2] = 1;
    for(int i = 3; i <= N; ++i){
        numPrimes[i] = numPrimes[i - 1] + (isNotPrime[i] == false ? 1 : 0);
    }
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    buildPrime();

    int q;
    cin >> q;
    while(q--){
        int n;
        cin >> n;
        int nPrimes = numPrimes[n] - numPrimes[n / 2]; // + 1 - 1
        cout << n - 1 - nPrimes << "\n";
    }
    return 0;
}